/* GDCHART 0.951a  GDC.C  6 Feb 2000 */
/* Copyright Bruce Verderaime 1998, 1999, 2000 */

#define GDC_INCL
#define GDC_LIB
#include "gdc.h"

struct	GDC_FONT_T	GDC_fontc[GDC_numfonts] = { (gdFontPtr)NULL, 8,  5,
											    (gdFontPtr)NULL, 8,  5,
											    (gdFontPtr)NULL, 12, 6,
											    (gdFontPtr)NULL, 13, 7,
											    (gdFontPtr)NULL, 16, 8,
											    (gdFontPtr)NULL, 15, 9 };

/* ------------------------------------------------------------------- *\ 
 * convert from enum GDC_font_size to gd fonts
 * for now load them all
 *	#defines and #ifdefs might enable loading only needed fonts
\* ------------------------------------------------------------------- */
void
load_font_conversions()
{
	GDC_fontc[GDC_pad].f     = gdFontTiny;
	GDC_fontc[GDC_TINY].f    = gdFontTiny;
	GDC_fontc[GDC_SMALL].f   = gdFontSmall;
	GDC_fontc[GDC_MEDBOLD].f = gdFontMediumBold;
	GDC_fontc[GDC_LARGE].f   = gdFontLarge;
	GDC_fontc[GDC_GIANT].f   = gdFontGiant;
}

/* ------------------------------------------------------------------ *\ 
 * count (natural) substrings (new line sep)
\* ------------------------------------------------------------------ */
short
cnt_nl( char	*nstr,
		int		*len )			/* strlen - max seg */
{
	short	c           = 1;
	short	max_seg_len = 0;
	short	tmplen      = 0;

	if( !nstr )
		{
		if( len )
			*len = 0;
		return 0;
		}

	while( *nstr )
		{
		if( *nstr == '\n' )
			{
			++c;
			max_seg_len = MAX( tmplen, max_seg_len );
			tmplen = 0;
			}
		else
			++tmplen;
		++nstr;
		}

	if( len )
		*len = MAX( tmplen, max_seg_len );		/* don't forget last seg */
	return c;
}

/* ------------------------------------------------------------------ *\ 
 * gd out a string with '\n's
\* ------------------------------------------------------------------ */
void
GDCImageStringNL( gdImagePtr		im,
				  struct GDC_FONT_T	*f,
				  int				x,
				  int				y,
				  char				*str,
				  int				clr,
				  GDC_justify_t		justify )
{
	int		i;
	int		len;
	int     max_len;
	short   strs_num = cnt_nl( str, &max_len );
	char    sub_str[max_len+1];

	len      = -1;
	strs_num = -1;
	i = -1;
	do
		{
		++i;
		++len;
		sub_str[len] = *(str+i);
		if( *(str+i) == '\n' ||
			*(str+i) == '\0' )
			{
			int	xpos;

			sub_str[len] = '\0';
			++strs_num;
			switch( justify )
			  {
			  case GDC_JUSTIFY_LEFT:	xpos = x;					 break;
			  case GDC_JUSTIFY_RIGHT:	xpos = x+f->w*(max_len-len); break;
			  case GDC_JUSTIFY_CENTER:
			  default:					xpos = x+f->w*(max_len-len)/2;
			  }
			gdImageString( im,
						   f->f,
						   xpos,
						   y + (f->h-1)*strs_num,
						   sub_str,
						   clr );
			len = -1;
			}
		}
	while( *(str+i) );
}

/* ------------------------------------------------------------------------ *\ 
 * todo:                                                                    *
 * really get a unique color from the color map                             *
\* ------------------------------------------------------------------------ */
long
get_uniq_color( gdImagePtr	im )
{
	return 0x123454;
}

/* ------------------------------------------------------------------------ */
void
GDC_destroy_image(void *im)
{
	if( im )
		gdImageDestroy( (gdImagePtr)im );
}

/* ------------------------------------------------------------------------ */
void
out_err( int			IMGWIDTH,
		 int			IMGHEIGHT,
		 FILE			*fptr,
		 unsigned long	BGColor,
		 unsigned long	LineColor,
		 char			*err_str )
{

	gdImagePtr	im;
	int			lineclr;
	int			bgclr;


	if( (GDC_hold_img & GDC_REUSE_IMAGE) &&
		GDC_image != (void*)NULL )
		im = GDC_image;
	else
		im = gdImageCreate( IMGWIDTH, IMGHEIGHT );

	bgclr    = gdImageColorAllocate( im, l2gdcal(BGColor) );
	lineclr  = gdImageColorAllocate( im, l2gdcal(LineColor) );

	gdImageString( im,
				   gdFontMediumBold,
				   IMGWIDTH/2 - GDC_fontc[GDC_MEDBOLD].w*strlen(err_str)/2,
				   IMGHEIGHT/3,
				   err_str,
				   lineclr );

	/* usually GDC_generate_img is used in conjunction with hard or hold options */
	if( GDC_generate_img )
		{
		fflush(fptr);			// clear anything buffered 
#ifdef GDC_PNG
		gdImagePng(im, fptr);
#else
		gdImageGif(im, fptr);
#endif
		}

	if( GDC_hold_img & GDC_EXPOSE_IMAGE )
		GDC_image = (void*)im;
	else
		gdImageDestroy(im);
	return;
}
